document.addEventListener("DOMContentLoaded", function() {

    var weightInput = document.getElementById("weightInput");
    var heightInput = document.getElementById("heightInput");
    var calculateBtn = document.getElementById("calculateBtn");
    var bmiElem = document.getElementById("bmi");

    calculateBtn.addEventListener("click", function(e) {
        var bmi = Number(weightInput.value) / Math.pow(Number(heightInput.value), 2);
        if (!bmi) return;
        bmi = Math.round(bmi * 100) / 100;
        var result = "";
        if (bmi >= 35) result = "Extremely Obese"
        else if (bmi >= 30) result = "Obese"
        else if (bmi >= 25) result = "Overweight"
        else if (bmi >= 18.5) result = "Normal weight"
        else result = "Underweight"

        bmiElem.innerHTML = "Your BMI is " + bmi + " kg/m<sup>2</sup> : <strong>" + result + "</strong>";
    });
});
